/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dan200.computercraft.client.model.turtle.ModelTransformer;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Vec3i;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.jspecify.annotations.Nullable;

public final class ModelRenderer {
    private ModelRenderer() {
    }

    public static void renderQuads(PoseStack transform, VertexConsumer buffer, List<BakedQuad> quads, int lightmapCoord, int overlayLight, int @Nullable [] tints) {
        PoseStack.Pose matrix = transform.last();
        boolean inverted = matrix.pose().determinant() < 0.0f;
        for (BakedQuad bakedquad : quads) {
            int idx;
            int tint = -1;
            if (tints != null && bakedquad.isTinted() && (idx = bakedquad.getTintIndex()) >= 0 && idx < tints.length) {
                tint = tints[bakedquad.getTintIndex()];
            }
            ModelRenderer.putBulkQuad(buffer, matrix, bakedquad, tint, lightmapCoord, overlayLight, inverted);
        }
    }

    private static void putBulkQuad(VertexConsumer buffer, PoseStack.Pose pose, BakedQuad quad, int colour, int lightmapCoord, int overlayLight, boolean invert) {
        Matrix4f matrix = pose.pose();
        Vec3i dirNormal = quad.getDirection().getNormal();
        Vector4f vector = new Vector4f();
        matrix.transform((float)dirNormal.getX(), (float)dirNormal.getY(), (float)dirNormal.getZ(), 0.0f, vector).normalize();
        float normalX = vector.x();
        float normalY = vector.y();
        float normalZ = vector.z();
        int[] vertices = quad.getVertices();
        for (int vertex = 0; vertex < 4; ++vertex) {
            int i = ModelTransformer.getVertexOffset(vertex, invert);
            float x = Float.intBitsToFloat(vertices[i]);
            float y = Float.intBitsToFloat(vertices[i + 1]);
            float z = Float.intBitsToFloat(vertices[i + 2]);
            matrix.transform(x, y, z, 1.0f, vector);
            float u = Float.intBitsToFloat(vertices[i + 4]);
            float v = Float.intBitsToFloat(vertices[i + 5]);
            buffer.addVertex(vector.x(), vector.y(), vector.z(), colour, u, v, overlayLight, lightmapCoord, normalX, normalY, normalZ);
        }
    }
}

